package com.tomas.ht_ydt;

import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.TextView;

import androidx.appcompat.app.AppCompatActivity;

import com.keyence.autoid.sdk.scan.DecodeResult;
import com.tomas.ht_ydt.ListData.Data;
import com.tomas.ht_ydt.ListData.Item_list;
import com.tomas.ht_ydt.ListData.Location_list;
import com.tomas.ht_ydt.ListData.Supplier_list;
import com.tomas.ht_ydt.lib.AlertProgress;
import com.tomas.ht_ydt.lib.Scanner;
import com.tomas.ht_ydt.lib.Settings;
import com.tomas.ht_ydt.lib.common.AsyncHttpClient;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import cn.pedant.SweetAlert.SweetAlertDialog;


public class MainActivity extends AppCompatActivity implements View.OnClickListener   {
    TextView txt_user, txt_device;
    AlertProgress alert;
    Map<String, Supplier_list> map_supplier;
    Map<String, Location_list> map_location;
    Map<String, Location_list> map_location_ok;
    Map<String, Location_list> map_location_ng;
    Map<String, Item_list> map_item;
    List<String> list_location, list_location_ok, list_location_ng;
    ArrayList<Data>data_part_no, data_supplier;
    String ng_area;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        map_supplier = new LinkedHashMap<>();
        map_location = new LinkedHashMap<>();
        map_location_ok = new LinkedHashMap<>();
        map_location_ng = new LinkedHashMap<>();
        map_item = new LinkedHashMap<>();
        list_location = new ArrayList<>();
        list_location_ok = new ArrayList<>();
        list_location_ng = new ArrayList<>();
        data_part_no = new ArrayList<>();
        data_supplier = new ArrayList<>();


        alert = new AlertProgress(MainActivity.this);

        txt_user = (TextView) findViewById(R.id.txt_user);
        txt_user.setText("User : "+ Settings.getLoginUser().getName());

        txt_device = (TextView) findViewById(R.id.txt_device);
        txt_device.setText("Device : "+ Settings.getDeviceNo());

        Supplier_Master();
        Items_Master();
        Location_Master();

    }



    @Override
    public void onClick(View view) {
        Intent intent;
        switch (view.getId()) {
            case R.id.btn_inbound:
                intent = new Intent(MainActivity.this, InboundMenu_Activity.class);
                startActivity(intent);
                break;

            case R.id.btn_outbound:
                intent = new Intent(MainActivity.this, OutboundMenu_Activity.class);
                startActivity(intent);
                break;

            case R.id.btn_stock_management:
                intent = new Intent(MainActivity.this, StockMenu_Activity.class);
                startActivity(intent);
                break;

            case R.id.btn_printer_setting:
                intent = new Intent(MainActivity.this, PrinterSetting_Activity.class);
                startActivity(intent);
                break;

            case R.id.btn_close:
                finishAffinity();
                System.exit(0);
                break;
        }
    }

    private void Location_Master() {
        list_location.clear();
        list_location_ok.clear();
        list_location_ng.clear();
        map_location.clear();
        map_location_ok.clear();
        map_location_ng.clear();
        alert.setMessage("           Loading environment....         ");
        alert.show();
        try {
            JSONObject json = new JSONObject();
            json.put("cmd", "LOCATION");

            new AsyncHttpClient(getApplicationContext(),
                    Settings.getMgmtList().get("web_api") + "/ht_api.php",
                    json.toString()) {
                @Override
                protected void onFinished(String response, int resp_code) {
                    Log.d(getString(R.string.tag), "Location response: " + response);

                    try{
                        JSONArray jArray = new JSONArray(response);
                        for(int i=0;i<jArray.length();i++) {
                            String id = jArray.getJSONObject(i).getString("id").trim();
                            String name = jArray.getJSONObject(i).getString("name").trim() == "null" ? "" : jArray.getJSONObject(i).getString("name").trim();
                            String factory_code = jArray.getJSONObject(i).getString("factory_code").trim()== "null" ? "" : jArray.getJSONObject(i).getString("factory_code").trim();
                            String description = jArray.getJSONObject(i).getString("description").trim()== "null" ? "" : jArray.getJSONObject(i).getString("description").trim();
                            String department_id = jArray.getJSONObject(i).getString("department_id").trim()== "null" ? "" : jArray.getJSONObject(i).getString("department_id").trim();
                            ng_area = jArray.getJSONObject(i).getString("ng_area").trim();


                            list_location.add(id);
                            map_location.put(id,new Location_list(id, name, factory_code, description, ng_area, department_id));

                            if (ng_area.trim().equals("0")){// OK location
                                list_location_ok.add(id);
                                map_location_ok.put(id,new Location_list(id, name, factory_code, description, ng_area, department_id));

                            }else {//NG location
                                list_location_ng.add(jArray.getJSONObject(i).getString("id").trim());
                                map_location_ng.put(id,new Location_list(id, name, factory_code, description, ng_area, department_id));
                            }

                        }
                        Settings.setMap_location(map_location);
                        Settings.setMap_location_ok(map_location_ok);
                        Settings.setMap_location_ng(map_location_ng);
                        Settings.setList_location(list_location);
                        Settings.setList_location_ok(list_location_ok);
                        Settings.setList_location_ng(list_location_ng);
                        alert.dismiss();
                    }catch (JSONException e) {
                        alert.dismiss();
                        new SweetAlertDialog(MainActivity.this, SweetAlertDialog.ERROR_TYPE)
                                .setTitleText("ERROR")
                                .setContentText(e.getMessage())
                                .show();
                    }
                }
            }.execute();

        }catch (JSONException e) {
            alert.dismiss();
            new SweetAlertDialog(MainActivity.this, SweetAlertDialog.ERROR_TYPE)
                    .setTitleText("ERROR")
                    .setContentText(e.getMessage())
                    .show();
        }
    }

    private void Items_Master() {
        map_item.clear();
        data_part_no.clear();
        alert.setMessage("           Loading environment....         ");
        alert.show();
        try {
            JSONObject json = new JSONObject();
            json.put("cmd", "ITEM");

            new AsyncHttpClient(getApplicationContext(),
                    Settings.getMgmtList().get("web_api") + "/ht_api.php",
                    json.toString()) {
                @Override
                protected void onFinished(String response, int resp_code) {
                    Log.d(getString(R.string.tag), "Items response: " + response);

                    try{
                        JSONArray jArray = new JSONArray(response);
                        for(int i=0;i<jArray.length();i++) {
                            String item_code = jArray.getJSONObject(i).getString("id").trim();
                            String item_name = jArray.getJSONObject(i).getString("name").trim();
                            String location = jArray.getJSONObject(i).getString("location_fix_id").trim();
                            String control_unit = jArray.getJSONObject(i).getString("control_unit").trim();

                            map_item.put(item_code, new Item_list(item_code, item_name, location, control_unit));
                            data_part_no.add(new Data(item_code));
                        }
                        Settings.setMap_item(map_item);
                        Settings.setData_part_no(data_part_no);
                        alert.dismiss();
                    }catch (JSONException e) {
                        alert.dismiss();
                        new SweetAlertDialog(MainActivity.this, SweetAlertDialog.ERROR_TYPE)
                                .setTitleText("ERROR")
                                .setContentText(e.getMessage())
                                .show();
                    }
                }
            }.execute();

        }catch (JSONException e) {
            alert.dismiss();
            new SweetAlertDialog(MainActivity.this, SweetAlertDialog.ERROR_TYPE)
                    .setTitleText("ERROR")
                    .setContentText(e.getMessage())
                    .show();
        }
    }
    private void Supplier_Master() {
        map_supplier.clear();
        data_supplier.clear();
        alert.setMessage("           Loading environment....         ");
        alert.show();
        try {
            JSONObject json = new JSONObject();
            json.put("cmd", "SUPPLIER");
            new AsyncHttpClient(getApplicationContext(),
                    Settings.getMgmtList().get("web_api") + "/ht_api.php",
                    json.toString()) {
                @Override
                protected void onFinished(String response, int resp_code) {
                    Log.d(getString(R.string.tag), "Supplier response: " + response);

                    try{
                        JSONArray jArray = new JSONArray(response);
                        data_supplier.add(new Data("All"));
                        map_supplier.put("All", new Supplier_list("All","",""));

                        for(int i=0;i<jArray.length();i++) {
                            data_supplier.add(new Data(jArray.getJSONObject(i).getString("name").trim()));

                            map_supplier.put(jArray.getJSONObject(i).getString("id").trim(),
                                    new Supplier_list(jArray.getJSONObject(i).getString("id").trim(),
                                            jArray.getJSONObject(i).getString("name").trim() == "null" ? "" : jArray.getJSONObject(i).getString("name").trim(),
                                            jArray.getJSONObject(i).getString("alias")));
                        }

                        Settings.setMap_supplier(map_supplier);
                        Settings.setData_supplier(data_supplier);
                        alert.dismiss();
                    }catch (JSONException e) {
                        alert.dismiss();
                        new SweetAlertDialog(MainActivity.this, SweetAlertDialog.ERROR_TYPE)
                                .setTitleText("ERROR")
                                .setContentText(e.getMessage())
                                .show();
                    }
                }
            }.execute();

        }catch (JSONException e) {
            alert.dismiss();
            new SweetAlertDialog(MainActivity.this, SweetAlertDialog.ERROR_TYPE)
                    .setTitleText("ERROR")
                    .setContentText(e.getMessage())
                    .show();
        }
    }

}